// ============================================================================
//  $Id: TReadoutElement.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TREADOUTELEMENT_HH
#define __TREADOUTELEMENT_HH

#include "TGlobals.hh"

class TDataElement;
class TModule;

class TReadoutElement
{

  private:
    Tint theID;
    TModule* theModule;

  public:
    TReadoutElement( TModule* module, Tint id = tIDunknown );
    TReadoutElement( const TReadoutElement& right );
    ~TReadoutElement();

  public:
    const TReadoutElement& operator=( const TReadoutElement& right );
    Tbool operator==( const TReadoutElement& right ) const;
    Tbool operator!=( const TReadoutElement& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutElement& right );

  public:
    TDataElement ReadData();

  public:
    Tint GetID() const;
    Tvoid SetID( Tint id );
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

};

inline TModule* TReadoutElement::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutElement::SetModule( TModule* module )
{
  theModule = module;
  return;
}

inline Tint TReadoutElement::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutElement::SetID( Tint id )
{
  theID = id;
  return;
}

#endif
