// ============================================================================
//  $Id: TReadoutSection.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutSection.hh"
#include "TDataSection.hh"

TReadoutSection::TReadoutSection( Tint id )
  : TReadoutSegmentList(), theID( id )
{;}

TReadoutSection::TReadoutSection( const TReadoutSection& right )
  : TReadoutSegmentList( right ), theID( right.theID )
{;}

TReadoutSection::~TReadoutSection()
{;}

TDataSection TReadoutSection::ReadData()
{
  TDataSection section( theID );

  for ( Tint i = 0; i < (Tint)size(); i ++ )
    section.push_back( ( (*this)[ i ] ).ReadData() );

  return( section );
}

Tostream& operator<<( Tostream& tos, const TReadoutSection& right )
{
  Tstring head = Twspace + "* Readout Section, ";
  tos << head << "ID: " << right.theID;
  tos << Twspace << "Capacity: " << right.capacity();
  tos << Twspace << "Entry: " << right.size();

  if ( right.empty() )
    return( tos );
  
  tos << Tendl;

  for ( Tint i = 0; i < (Tint)right.size(); i ++ ) {
    tos << right[ i ];
    if ( i != (Tint)right.size() - 1 )
      tos << Tendl;
  }

  return( tos );
}

const TReadoutSection& TReadoutSection::operator=( const TReadoutSection& right )
{
  *( (TReadoutSegmentList*)this ) = *( (TReadoutSegmentList*)(&right) );
  theID = right.theID;
  return( *this );
}

Tbool TReadoutSection::operator==( const TReadoutSection& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutSegmentList*)this ) == *( (TReadoutSegmentList*)(&right) ) );
  ret &= ( theID == right.theID );
  return( ret );
}

Tbool TReadoutSection::operator!=( const TReadoutSection& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutSegmentList*)this ) != *( (TReadoutSegmentList*)(&right) ) );
  ret |= ( theID != right.theID );
  return( ret );
}
