// ============================================================================
//  $Id: TOutputHtmlFileStream.cc,v 1.4 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputHtmlFileStream.hh"

TOutputHtmlFileStream::TOutputHtmlFileStream()
  : Tofstream(), theInformationTable()
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table )
  : Tofstream( filename.c_str() ), theInformationTable( table )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const TRunInformationTable& table )
  : Tofstream(), theInformationTable( table )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename )
  : Tofstream( filename.c_str() ), theInformationTable()
{;}

TOutputHtmlFileStream::~TOutputHtmlFileStream()
{;}

TOutputHtmlFileStream& TOutputHtmlFileStream::MakeTable()
{
  (Tofstream&)(*this) << "<blockquote>" << Tendl;
  (Tofstream&)(*this) << " <table border=1 width=\"100%\">" << Tendl;

  TstringList itemlist = theInformationTable.GetItemList();
  TstringList valuelist = theInformationTable.GetValueList();
  Tint nrow = theInformationTable.GetNumberOfRows();

  for ( Tint i = 0; i < nrow; i ++ ) {
    (Tofstream&)(*this) << "  <tr>" << Tendl;
    (Tofstream&)(*this) << "   <td><b>" << (itemlist[ i ]).c_str() << "</b></td>" << Tendl;
    (Tofstream&)(*this) << "   <td>" << (valuelist[ i ]).c_str() << "</td>" << Tendl;
    (Tofstream&)(*this) << "  </tr>" << Tendl;
  }

  (Tofstream&)(*this) << " </table>" << Tendl;
  (Tofstream&)(*this) << "</blockquote>" << Tflush;

  return( *this );
}

Tvoid TOutputHtmlFileStream::Open( const Tstring& filename )
{
  if ( ! this -> is_open() )
    open( filename.c_str() );
  return;
}

Tvoid TOutputHtmlFileStream::Close()
{
  if ( this -> is_open() )
    close();
  return;
}

