// ============================================================================
//  $Id: TSystemTimer.cc,v 1.4 2002/12/07 13:14:59 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSystemTimer.hh"

TSystemTimer::TSystemTimer()
  : theValidTimes( Tfalse ), theBeginOfRealTime( -1 ), theEndOfRealTime( -1 )
{;}

TSystemTimer::~TSystemTimer()
{;}

Tostream& operator<<( Tostream& tos, const TSystemTimer& right )
{
  if ( right.IsValid() ) {
    tos << "Real=" << right.GetRealElapsedTime() << "s ";
    tos << "User=" << right.GetUserElapsedTime() << "s ";
    tos << "User(child)=" << right.GetUserElapsedTimeOfChildren() << "s ";
    tos << "Sys=" << right.GetSystemElapsedTime() << "s ";
    tos << "Sys(child)=" << right.GetSystemElapsedTimeOfChildren() << "s";
  } else {
    tos << "Real=***s User=***s User(child)=***s Sys=***s Sys(child)=***s";
  }
  return( tos );
}

Tdouble TSystemTimer::GetRealElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetRealElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  Tdouble diff = theEndOfRealTime - theBeginOfRealTime;
  return( diff / sysconf( _SC_CLK_TCK ) );
}

Tdouble TSystemTimer::GetSystemElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetSystemElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  Tdouble diff = theEndOfTimes.tms_stime - theBeginOfTimes.tms_stime;
  return( diff / sysconf( _SC_CLK_TCK ) );
}

Tdouble TSystemTimer::GetSystemElapsedTimeOfChildren() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetSystemElapsedTimeOfChildren: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  Tdouble diff = theEndOfTimes.tms_cstime - theBeginOfTimes.tms_cstime;
  return( diff / sysconf( _SC_CLK_TCK ) );
}

Tdouble TSystemTimer::GetUserElapsedTime() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetUserElapsedTime: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  Tdouble diff = theEndOfTimes.tms_utime - theBeginOfTimes.tms_utime;
  return( diff / sysconf( _SC_CLK_TCK ) );
}

Tdouble TSystemTimer::GetUserElapsedTimeOfChildren() const
{
  if ( theValidTimes == Tfalse ) {
    Tstring head = "TSystemTimer::GetUserElapsedTimeOfChildren: ";
    Tcerr << head << "timer not stopped or times not recorded" << Tendl;
  }
  Tdouble diff = theEndOfTimes.tms_cutime - theBeginOfTimes.tms_cutime;
  return( diff / sysconf( _SC_CLK_TCK ) );
}

Tvoid TSystemTimer::Start()
{
  theValidTimes = Tfalse;
  theBeginOfRealTime = times( &theBeginOfTimes );
  return;
}

Tvoid TSystemTimer::Pause()
{
  return;
}

Tvoid TSystemTimer::Stop()
{
  theEndOfRealTime = times( &theEndOfTimes );
  theValidTimes = Ttrue;
  return;
}
