// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "DarkStartCommand.hh"
#include "DarkReadoutList.hh"
#include "Dark1DHistogramExtractor.hh"
#include "DarkGraphExtractor.hh"
#include "TAnalysisStation.hh"
#include "TRoot1DHistogram.hh"
#include "TRootGraph.hh"
#include "TRootAnalyser.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"

static const Tstring name = "dark-start";
static const Tstring desc = "JPSѤΥǡ򳫻Ϥޤ\nΥޥɤϾŪˤstartޥɤ˵ۼΤפˤʤޤ";

DarkStartCommand::DarkStartCommand()
  : TCommand( name, desc ), theReadoutList( 0 )
{
  theReadoutList = new DarkReadoutList();
}

DarkStartCommand::~DarkStartCommand()
{
  delete theReadoutList;
}

Tvoid DarkStartCommand::Execute( const TstringList& arguments )
{
  TAnalysisStation* station =
    new TAnalysisStation( new TRootAnalyser( 600, 800 ) );

  TRoot1DHistogram hist = TRoot1DHistogram( "demo", "JPS 2002", 100, 0, 4095 );
  TRootGraph graph;
  //graph.SetMarkerStyle( 8 );
  //graph.SetMarkerSize( 1.2 );

  Dark1DHistogramExtractor histext;
  DarkGraphExtractor grext;
  station -> DivideCanvas( 1, 2 );

  const Tint nevents = 100;
  
  TVmeMpx201aModule* mpx201a = theReadoutList -> GetFadc();
  mpx201a -> Clear();
  const Tint rpv130base = 0x1000;
  TVmeRpv130Module rpv130( rpv130base );


  mpx201a -> SetSamplingRate( 15 );  // 1/16
  //mpx201a -> SetSamplingRate( 0 );  // 1/1


  mpx201a -> SetDataCaptureMode( TVmeMpx201aModule::tTransientMode );
  mpx201a -> SetEventSynchronisationMode( TVmeMpx201aModule::tExternalSynchronisationMode );
  mpx201a -> EnableAccessToDaughterBoard();

  rpv130.Pulse( 1 );
  rpv130.LevelDown( 0 );
  rpv130.LevelUp( 0 );

  for ( Tint i = 0; i < nevents; i ++ ) {
    Tcout << "### event " << i << Tendl;

    mpx201a -> EnableAcquisition();
    rpv130.LevelDown( 0 );

    Tint nsleep = 0;

    while ( 1 ) {

      if ( mpx201a -> IsMemoryBlockFull() ) {
	Tcout << "### data filled." << Tendl;
	theReadoutList -> GetScaler() -> Update();
	theReadoutList -> GetClock() -> Update();
	
	mpx201a -> SetBufferOrientation( 1 );

	TDataRecord record = theReadoutList -> ReadData();
	//Tcout << record << endl;


	station -> Fill1DHistogram( hist, record, histext );
	station -> MoveCanvas( 1 );
  	hist.Draw();
  	station -> FillGraph( graph, record, grext );

  	station -> MoveCanvas( 2 );
	graph.Clear();
  	graph.Draw( "ap" );
  	station -> Update();

	rpv130.Pulse( 1 );
	rpv130.Pulse( 3 );
	rpv130.LevelUp( 0 );

	mpx201a -> DisableAcquisition();
	mpx201a -> SetMemoryBlockFullFlag( 0 );
	mpx201a -> SetDataOverFlowFlag( 0 );
	mpx201a -> EnableSystemFailure();
	mpx201a -> SetScanCompleteFlag( 0 );

	break;
      } else {
	Tcout << "no data: " << nsleep << " times sleep." << Tendl;
	sleep( 1 );
	nsleep ++;
	if ( nsleep > 30 ) {
	  Tcout << "### event #" << i << ": no data taking." << Tendl;
	  break;
	}
      }
    }


  }
  station -> EventLoop();
  return;
}
