// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAnalysisStation.hh"
#include "TRoot1DHistogram.hh"
#include "TAnalysisDataExtractor.hh"
#include "TDataRecord.hh"
#include "TRootGraph.hh"
#include "TRootAnalyser.hh"
#include "TMultipleData.hh"

TAnalysisStation* TAnalysisStation::theAnalysisStation = 0;

TAnalysisStation::TAnalysisStation( TRootAnalyser* analyser )
  : theAnalyser( analyser )
{
  theAnalysisStation = this;
}

TAnalysisStation::~TAnalysisStation()
{
  if ( theAnalyser != 0 )
    delete theAnalyser;
}

Tvoid TAnalysisStation::Fill1DHistogram( TRoot1DHistogram& hist, 
					 TDataRecord& record, 
					 TAnalysisDataExtractor& extractor )
{
  theAnalyser -> Fill1DHistogram( hist, record, extractor );
  return;
}

Tvoid TAnalysisStation::FillGraph( TRootGraph& graph, TDataRecord& record,
				   TAnalysisDataExtractor& extractor )
{
  theAnalyser -> FillGraph( graph, record, extractor );
  return;
}

Tvoid TAnalysisStation::Update()
{
  theAnalyser -> Update();
  return;
}

Tvoid TAnalysisStation::DivideCanvas( Tint x, Tint y )
{
  theAnalyser -> DivideCanvas( x, y );
  return;
}

Tvoid TAnalysisStation::MoveCanvas( Tint ptr )
{
  theAnalyser -> MoveCanvas( ptr );
  return;
}

Tvoid TAnalysisStation::EventLoop( Tbool ret )
{
  theAnalyser -> Run( ret );
  return;
}
