// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSTREAMABLEOBJECT_HH
#define __TSTREAMABLEOBJECT_HH

#include "TGlobals.hh"

class TOutputObjectStream;

class TStreamableObject
{

  protected:
    Tobject_t theObjectType;
    Tint theID;

  public:
    TStreamableObject( Tobject_t objecttype, Tint id );
    TStreamableObject( const TStreamableObject& right );

  public:
    Tobject_t GetObjectType() const;
    Tint GetID() const;
    Tvoid SetObjectType( Tobject_t objecttype );
    Tvoid SetID( Tint id );

  public:
    virtual const TStreamableObject& operator=( const TStreamableObject& right );
    virtual Tbool operator==( const TStreamableObject& right ) const;
    virtual Tbool operator!=( const TStreamableObject& right ) const;

  protected:
    virtual ~TStreamableObject();

  public:
    virtual Tint GetDataSize() = 0;
    virtual Tint WriteData( TOutputObjectStream* output ) = 0;

};

inline Tobject_t TStreamableObject::GetObjectType() const
{
  return( theObjectType );
}

inline Tint TStreamableObject::GetID() const
{
  return( theID );
}

inline Tvoid TStreamableObject::SetObjectType( Tobject_t objecttype )
{ 
  theObjectType = objecttype;
}

inline Tvoid TStreamableObject::SetID( Tint id )
{
  theID = id;
}

#endif
