// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TEVENTMANAGER_HH
#define __TEVENTMANAGER_HH

#include "TGlobals.hh"
#include "TEventAction.hh"
#include "TEvent.hh"

class TRun;
class TEvent;
class TEventAction;

class TEventManager
{

  public:
    enum { tDefaultStackSize = 100 };

  private:
    Tint theStackSize;
    Tint theNumberOfEvents;
    TEventAction* theEventAction;
    TEvent theEvent;

  private:
    static TEventManager* theEventManager;

  public:
    TEventManager( Tint stacksize = tDefaultStackSize );
    ~TEventManager();

  public:
    Tint GetStackSize() const;
    Tint GetNumberOfEvents() const;
    const TEvent& GetEvent() const;
    TEventAction* GetEventAction() const;
    Tvoid SetStackSize( Tint stacksize );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetEvent( const TEvent& event );
    Tvoid SetEventAction( TEventAction* action );

  public:
    Tvoid RecordEvent( const TRun& run );
    const TEvent& TakeEvent();

  public:
    static TEventManager* GetEventManager();

};

inline TEventManager* TEventManager::GetEventManager()
{
  return( theEventManager );
}

inline Tint TEventManager::GetStackSize() const
{
  return( theStackSize );
}

inline Tint TEventManager::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TEvent& TEventManager::GetEvent() const
{
  return( theEvent );
}

inline TEventAction* TEventManager::GetEventAction() const
{
  return( theEventAction );
}

inline Tvoid TEventManager::SetStackSize( Tint stacksize )
{
  theStackSize = stacksize;
  return;
}

inline Tvoid TEventManager::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid TEventManager::SetEvent( const TEvent& event )
{
  theEvent = event;
  return;
}

inline Tvoid TEventManager::SetEventAction( TEventAction* action )
{
  if ( theEventAction )
    delete theEventAction;
  theEventAction = action;
  return;
}

#endif
