// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TINPUTOBJECTSHAREDMEMORY_HH
#define __TINPUTOBJECTSHAREDMEMORY_HH

#include "TGlobals.hh"
#include "TObjectSharedMemory.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSharedMemory
  : public TObjectSharedMemory, public TInputObjectStream
{

  private:
    Tbool theReadSuccessFlag;

  public:
    TInputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TInputObjectSharedMemory( TObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TInputObjectSharedMemory();

  public:
    Tint ReadData( TStreamableObject& object );

  public:
    Tbool IsReadSuccess() const;

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& id, Tint& entries );

};

inline Tbool TInputObjectSharedMemory::IsReadSuccess() const
{
  return( theReadSuccessFlag );
}

#endif
