// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TCommand.hh"
#include "TExitCommand.hh"
#include "TListCommand.hh"
#include "TDateCommand.hh"
#include "TShowRunManagerCommand.hh"
#include "TShowNetworkStatusCommand.hh"
#include "TReadFileCommand.hh"
#include "TShellCommand.hh"
#include "TExecuteCommand.hh"
#include "TStartCommand.hh"
#include "TStopCommand.hh"
#include "TPauseCommand.hh"
#include "TResumeCommand.hh"
#include "THelpCommand.hh"

TRunManager* TRunManager::theRunManager = 0;

TRunManager::TRunManager( TUserInterface* ui )
  : theStatus( tStatusDead ), theWaitingCommands(), 
    theRun(), theRunAction( 0 ), theEventManager( 0 ), theUserInterface( ui )
{
  if ( theRunManager ) {
    Tcerr << "TRunManager::TRunManager: RunManager constructed twice." << Tendl;
    exit( -EFAULT );
  }
  theRunManager = this;
  theEventManager = new TEventManager();

  if ( theUserInterface != 0 ) {
    SetUserCommand( new TExitCommand() );
    SetUserCommand( new TListCommand() );
    SetUserCommand( new TDateCommand() );
    SetUserCommand( new TShowRunManagerCommand() );
    SetUserCommand( new TShowNetworkStatusCommand() );
    SetUserCommand( new TReadFileCommand() );
    SetUserCommand( new TShellCommand() );
    SetUserCommand( new TExecuteCommand() );
    SetUserCommand( new THelpCommand() );
    SetUserCommand( new TStartCommand() );
    SetUserCommand( new TStopCommand() );
    SetUserCommand( new TPauseCommand() );
    SetUserCommand( new TResumeCommand() );
  }
  theStatus = tStatusStandby;


  Tcout << "========================================================" << Tendl;
  Tcout << " Project: " << Tproject << Tendl;
  Tcout << " Version: " << Tversion << Tendl;
  Tcout << " ----" << Tendl;
  Tcout << " 8050 Ikarashi 2-no-chou, Niigata City, 950-2181, Japan" << Tendl;
  Tcout << " Phone & Fax: +81-25-262-6138" << Tendl;
  Tcout << " Go IWAI iwai@hep.sc.niigata-u.ac.jp" << Tendl;
  Tcout << "========================================================" << Tendl;
}

TRunManager::~TRunManager()
{
  delete theEventManager;
  if ( theUserInterface )
    delete theUserInterface;
  if ( theRunAction )
    delete theRunAction;
}

Tvoid TRunManager::SessionStart() const
{
  theUserInterface -> SessionStart();
  return;
}

Tint TRunManager::SetUserCommand( TCommand* command ) const
{
  if ( theUserInterface == 0 ) {
    Tcerr << "TRunManager::SetUserCommand: unset user interface." << Tendl;
    return( -EFAULT );
  }
  return( theUserInterface -> AddCommand( command ) );
}

Tvoid TRunManager::ShowStatus() const
{
  Tcout << "Status: ";
  switch ( theStatus ) {
    case tStatusStandby:
      Tcout << "Standby - [start] or [stop] command is acceptable." << Tendl;
      break;
    case tStatusReady:
      Tcout << "Ready - waiting begin of transaction(trigger), [pause] command is acceptable." << Tendl;
      break;
    case tStatusBusy:
      Tcout << "Busy - just taking data from HW/SW." << Tendl;
      break;
    case tStatusIdle:
      Tcout << "Idle - if accept [resume] command, the status is going to transit Ready." << Tendl;
      break;
    case tStatusWaitingReady:
      Tcout << "WaitingReady - waiting for status ready." << Tendl;
      break;
    case tStatusDead:
      Tcout << "Dead - not allocate, or trouble ?" << Tendl;
      break;
    case tStatusUnknown:
    default:
      Tcout << "Unknown - unknown status." << Tendl;
      break;
  }
  return;
}

Tvoid TRunManager::ShutdownRun()
{
  if ( theStatus != tStatusStandby ) {
    ShowStatus();
    return;
  }
  if ( theRunAction )
    theRunAction -> FinalOfRunAction( theRun );
  theStatus = tStatusDead;
  return;
}

Tvoid TRunManager::StartRun()
{
  if ( theStatus != tStatusStandby ) {
    ShowStatus();
    return;
  }
  theRun.Clear();
  Tint runid = theRun.GetRunID();
  theRun.SetRunID( ++ runid );
  if ( theRunAction )
    theRunAction -> BeginOfRunAction( theRun );
  theStatus = tStatusReady;
  return;
}

Tvoid TRunManager::StartRun( Tint runid )
{
  if ( theStatus != tStatusStandby ) {
    ShowStatus();
    return;
  }
  theRun.Clear();
  theRun.SetRunID( runid );
  if ( theRunAction )
    theRunAction -> BeginOfRunAction( theRun );
  theStatus = tStatusReady;
  return;
}

Tvoid TRunManager::StopRun()
{
  if ( theStatus != tStatusIdle ) {
    ShowStatus();
    return;
  }
  if ( theRunAction )
    theRunAction -> EndOfRunAction( theRun );
  theStatus = tStatusStandby;
  return;
}

Tvoid TRunManager::PauseRun()
{
  if ( theStatus == tStatusBusy ) {
    theStatus = tStatusWaitingReady;
    return;
  } else if ( theStatus != tStatusReady ) {
    ShowStatus();
    return;
  }
  theStatus = tStatusIdle;
  return;
}

Tvoid TRunManager::ResumeRun()
{
  if ( theStatus != tStatusIdle )
    return;
  theStatus = tStatusReady;
  return;
}

Tvoid TRunManager::DoEventLoop()
{
  if ( theStatus != tStatusReady ) {
    ShowStatus();
    return;
  }

  while ( theStatus != tStatusIdle ) {
    theStatus = tStatusBusy;
    theEventManager -> TakeEvent();
    theEventManager -> RecordEvent( theRun );
    if ( theStatus == tStatusWaitingReady )
      break;
  }

  return;
}
