// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TRun.hh"
#include "TEvent.hh"
#include "TEventList.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareAdcModule.hh"

int main( int argc, char** argv, char** envv )
{
  TRun run( 4 );

  TSoftwareScalerModule scaler;
  TSoftwareTimerModule timer;
  TSoftwareClockModule clock;
  TSoftwareAdcModule adc;
  TReadoutList list( 1000 );
  TReadoutSection sec1( 1100 );
  TReadoutSegment seg1( &scaler, 1100 );
  TReadoutSegment seg2( &clock, 1200 );
  TReadoutSegment seg3( &timer, 1300 );
  TReadoutSegment seg4( &adc, 1400 );
  sec1.push_back( seg1 );
  sec1.push_back( seg2 );
  sec1.push_back( seg3 );
  sec1.push_back( seg4 );
  list.push_back( sec1 );


  for ( Tint evtid = 0; evtid < 10; evtid ++ ) {
    TEvent event = TEvent( evtid, list.ReadData() );
    run.RecordEvent( event );
    //Tcout << run.GetNumberOfEvents() << Tendl;
    TEventList ev = run.GetEventList();
    Tcout << "######################################" << Tendl;
    for ( Tint i = 0; i < (Tint)ev.size(); i ++ )
	Tcout << ev[ i ].GetDataRecord() << Tendl;
    Tcout << "######################################" << Tendl << Tendl;

    scaler.Update();
    clock.Update();
    timer.Update();
    adc.Update();
  }

  return( 0 );
}
