// ============================================================================
//  $Id: BtDummyModuleManager.cc,v 1.2 2002/12/07 23:06:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtDummyModuleManager.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TRunInformationTable.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "parameter.h"

BtDummyModuleManager* BtDummyModuleManager::theModuleManager = 0;

BtDummyModuleManager::BtDummyModuleManager()
  : theAdc( 0 ), theScaler( 0 ), theRunInfo( 0 ), theTimer( 0 ), theClock( 0 ),
    theRunBeginReadoutList( 0 ), theRunEndReadoutList( 0 ),
    theEventReadoutList( 0 ), theScalerEventReadoutList( 0 )
{
  defineModule();
  defineReadoutList();
  theModuleManager = this;
}

BtDummyModuleManager::~BtDummyModuleManager()
{
  delete theAdc;
  delete theScaler;
  delete theRunInfo;
  delete theTimer;
  delete theClock;

  delete theRunBeginReadoutList;
  delete theRunEndReadoutList;
  delete theEventReadoutList;
  delete theScalerEventReadoutList;

  theModuleManager = 0;
}

Tvoid BtDummyModuleManager::defineModule()
{

  Trandom_t rnd = tRandomGaussian;
  theAdc = new TSoftwareAdcModule( BTadc_nch, BTadc_scale, rnd, BTadc_slot );


  theScaler = new TSoftwareScalerModule( BTscaler_nch, BTscaler_slot );


  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "Shift Name" );
  itemlist.push_back( "Beam Energy" );
  itemlist.push_back( "Run Type" );
  TRunInformationTable table( itemlist );
  theRunInfo = new TSoftwareRunInformationModule( table, BTruninfo_slot );


  theTimer = new TSoftwareTimerModule( Tusec, BTtimer_nch, BTtimer_slot );


  theClock = new TSoftwareClockModule( BTclock_nch, BTclock_slot );


  return;
}

Tvoid BtDummyModuleManager::defineReadoutList()
{
  theRunBeginReadoutList = new TReadoutList( BTrunbegin );
  theRunEndReadoutList = new TReadoutList( BTrunend );
  theEventReadoutList = new TReadoutList( BTevent );
  theScalerEventReadoutList = new TReadoutList( BTscalerevent );

  // define run begin
  TReadoutSection sec0( BTrunbegin );
  TReadoutSegment seg0( theRunInfo, BTrunbegin + 0 );
  TReadoutSegment seg1( theClock, BTrunbegin + 1 );
  TReadoutSegment seg2( theScaler, BTrunbegin + 2 );
  sec0.push_back( seg0 );
  sec0.push_back( seg1 );
  sec0.push_back( seg2 );
  theRunBeginReadoutList -> push_back( sec0 );


  // define run end
  TReadoutSection sec1( BTrunend );
  TReadoutSegment seg3( theRunInfo, BTrunend + 0 );
  TReadoutSegment seg4( theClock, BTrunend + 1 );
  TReadoutSegment seg5( theScaler, BTrunend + 2 );
  sec1.push_back( seg3 );
  sec1.push_back( seg4 );
  sec1.push_back( seg5 );
  theRunEndReadoutList -> push_back( sec1 );


  // event data
  TReadoutSection sec2( 1234 );
  TReadoutSegment seg6( theAdc, 5678 );
  TReadoutSegment seg7( theTimer, 1002 );
  sec2.push_back( seg6 );
  sec2.push_back( seg7 );
  theEventReadoutList -> push_back( sec2 );


  // scaler event
  TReadoutSection sec3( BTscalerevent );
  TReadoutSegment seg8( theScaler, BTscalerevent + 0 );
  TReadoutSegment seg9( theTimer, BTscalerevent + 1 );
  sec3.push_back( seg8 );
  sec3.push_back( seg9 );
  theScalerEventReadoutList -> push_back( sec3 );


  return;
}

Tvoid BtDummyModuleManager::Update()
{
  theAdc -> Update();
  theScaler -> Update();
  theTimer -> Update();
  theClock -> Update();
  return;
}
