// ============================================================================
//  $Id: TAnalysisStopCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TAnalysisStopCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring name = "/analysis/stop";
static const Tstring desc = "stop an analysis.";

TAnalysisStopCommand::TAnalysisStopCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, name, desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStopCommand::~TAnalysisStopCommand()
{;}

Tvoid TAnalysisStopCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StopAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StopAnalysis( arguments[ i ] );
  }
  return;
}
