// ============================================================================
//  $Id: TReadFileCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadFileCommand.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"

static const Tstring name = "/option/readfile";
static const Tstring desc = "open a object file, dump to screen.\nexample> readfile filename.drec";

TReadFileCommand::TReadFileCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TReadFileCommand::~TReadFileCommand()
{;}

Tvoid TReadFileCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  const Tstring filename = arguments[ 0 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetDataSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile -> GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  delete ifile;

  return;
}
