// ============================================================================
//  $Id: TCamacCoincidenceRegisterModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacCoincidenceRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacCoincidenceRegisterModule::TCamacCoincidenceRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacCoincidenceRegisterModule::TCamacCoincidenceRegisterModule( const TCamacCoincidenceRegisterModule& right )
  : TCamacModule( right )
{;}

TCamacCoincidenceRegisterModule::~TCamacCoincidenceRegisterModule()
{;}

const TCamacCoincidenceRegisterModule& TCamacCoincidenceRegisterModule::operator=( const TCamacCoincidenceRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacCoincidenceRegisterModule::operator==( const TCamacCoincidenceRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacCoincidenceRegisterModule::operator!=( const TCamacCoincidenceRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacCoincidenceRegisterModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Read();
    TDataElement element( &theCamacData, tTypeUnsignedInt, itostr( i ), 1 );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TCamacCoincidenceRegisterModule::FillData( const TDataElement& element )
{
  Tint ch = atoi( element.GetID().c_str() );
  Tstring head = "TCamacCoincidenceRegisterModule::FillData: ";
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << head << "invalid ID" << Tendl;
    Tcerr << head << "status is filled." << Tendl;
    ( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read();
    ( (TDataElement*)(&element) ) -> FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}
