// ============================================================================
//  $Id: TCamacCrateController.hh,v 1.2 2002/12/06 12:07:06 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCAMACCRATECONTROLLER_HH
#define __TCAMACCRATECONTROLLER_HH

#include "globals.h"

#define CC7x00_IOC_MAGIC 0xcc
#define IOC_TEST_ONLINE _IO( CC7x00_IOC_MAGIC, 0x02 )
#define IOC_RESET_CRATE _IO( CC7x00_IOC_MAGIC, 0x03 )
#define IOC_SET_Z _IO( CC7x00_IOC_MAGIC, 0x04 )
#define IOC_SET_C _IO( CC7x00_IOC_MAGIC, 0x05 )
#define IOC_SET_I _IO( CC7x00_IOC_MAGIC, 0x06 )
#define IOC_RESET_I _IO( CC7x00_IOC_MAGIC, 0x07 )
#define IOC_SET_EI _IO( CC7x00_IOC_MAGIC, 0x08 )
#define IOC_RESET_EI _IO( CC7x00_IOC_MAGIC, 0x09 )
#define IOC_SET_LI _IO( CC7x00_IOC_MAGIC, 0x0a )
#define IOC_RESET_LI _IO( CC7x00_IOC_MAGIC, 0x0b )
#define IOC_SET_CN _IOW( CC7x00_IOC_MAGIC, 0x0c, TUint )
#define IOC_WAIT_LAM _IOW( CC7x00_IOC_MAGIC, 0x0d, TUint** )
#define IOC_GET_LAM _IOR( CC7x00_IOC_MAGIC, 0x0e, TUint* )
#define IOC_CAM16 _IOR( CC7x00_IOC_MAGIC, 0x0f, struct CamacDriverInterface )
#define IOC_CAM24 _IOR( CC7x00_IOC_MAGIC, 0x10, struct CamacDriverInterface )

class TCamacCrateController
{

  private:
    TcamacCrateController_t theCrateControllerType;
    Tint theCrateID;
    Tint theFileDescriptor;
    Tint theStatus;
    Tbool theISA7000;

  public:
    TCamacCrateController();
    TCamacCrateController( TcamacCrateController_t cctype );
    ~TCamacCrateController();

  public:
    Tvoid Open();
    Tvoid Close();
    Tbool IsOnline();
    Tbool IsOpen();
    Tvoid Reset();
    Tvoid Initialize();
    Tvoid Clear();
    Tvoid SetInhibition();
    Tvoid ReleaseInhibition();
    Tvoid EnableInterrupt();
    Tvoid DisableInterrupt();

  public:
    TcamacCrateController_t GetCrateControllerType() const;
    Tint GetCrateID() const;
    Tint GetFileDescriptor() const;
    Tint GetStatus() const;
    Tvoid SetCrateControllerType( TcamacCrateController_t type );
    Tvoid SetCrateID( Tint crateid );
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetStatus( Tint status );
    Tbool IsISA7000() const;

};

inline TcamacCrateController_t TCamacCrateController::GetCrateControllerType() const
{
  return( theCrateControllerType );
}

inline Tint TCamacCrateController::GetCrateID() const
{
  return( theCrateID );
}

inline Tint TCamacCrateController::GetFileDescriptor() const
{
  return( theFileDescriptor );
}

inline Tint TCamacCrateController::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TCamacCrateController::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TCamacCrateController::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TCamacCrateController::IsISA7000() const
{
  return( theISA7000 );
}

#endif
