// ============================================================================
//  $Id: TCamacInterruptRegisterModule.hh,v 1.1 2002/12/06 12:07:29 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCAMACINTERRUPTREGISTERMODULE_HH
#define __TCAMACINTERRUPTREGISTERMODULE_HH

#include "globals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;

class TCamacInterruptRegisterModule
  : public TCamacModule
{

  public:
    TCamacInterruptRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch = 1, Tdata_t datalen = t16bitModule );
    TCamacInterruptRegisterModule( const TCamacInterruptRegisterModule& right );
    ~TCamacInterruptRegisterModule();

  public:
    const TCamacInterruptRegisterModule& operator=( const TCamacInterruptRegisterModule& right );
    Tbool operator==( const TCamacInterruptRegisterModule& right ) const;
    Tbool operator!=( const TCamacInterruptRegisterModule& right ) const;

  public:
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  public:
    Tint Initialize();
    Tint ReadInterruptRegister();
    Tint ReadInterruptMaskRegister();
    Tint ClearInterruptMaskRegister();
    Tint WriteInterruptMaskRegister( Tint data );
    Tint ClearInterruptRegister();
    Tint DisableInterruptOutput();
    Tint EnableInterruptOutput();

};

#endif
