// ============================================================================
//  $Id: TSoftwareRunInformationModule.cc,v 1.4 2002/12/08 21:21:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSoftwareRunInformationModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareRunInformationModule::TSoftwareRunInformationModule()
  : TSoftwareModule( 0 ), theRunInformationTable()
{
  theRunInformationTable.Clear();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TRunInformationTable& table )
  : TSoftwareModule( 0 ), theRunInformationTable( table )
{;}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right )
  : TSoftwareModule( right ), theRunInformationTable( right.theRunInformationTable )
{;}

TSoftwareRunInformationModule::~TSoftwareRunInformationModule()
{;}

Tvoid TSoftwareRunInformationModule::FillData( const TDataSegment& segment )
{
  Tstring item;
  Tstring value;

  for ( Tint i = 0; i < theRunInformationTable.GetNumberOfRows(); i ++ ) {
    item = theRunInformationTable.GetItem( i );
    value = theRunInformationTable.GetValue( i );
    TDataElement element( &value, tTypeString, item, 1 );
    ((TDataElementList*)(&segment)) -> push_back( element );
  }

  return;
}

Tvoid TSoftwareRunInformationModule::FillData( const TDataElement& element )
{
  Tint row = atoi( element.GetID().c_str() );

  if ( row < 0 || row >= theRunInformationTable.GetNumberOfRows() ) {
    Tcerr << "TSoftwareRunInformationModule::FillData: invalid ID" << Tendl;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    Tstring item = theRunInformationTable.GetItem( row );
    Tstring value = theRunInformationTable.GetValue( row );
    ((TDataElement*)(&element)) -> FillData( &value, tTypeString, 1 );
    ((TDataElement*)(&element)) -> SetID( item );
  }

  return;
}

const TSoftwareRunInformationModule& TSoftwareRunInformationModule::operator=( const TSoftwareRunInformationModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theRunInformationTable = right.theRunInformationTable;
  return( *this );
}

Tbool TSoftwareRunInformationModule::operator==( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theRunInformationTable == right.theRunInformationTable );
  return( retval );
}

Tbool TSoftwareRunInformationModule::operator!=( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theRunInformationTable != right.theRunInformationTable );
  return( retval );
}

Tint TSoftwareRunInformationModule::Clear()
{
  TstringList valuelist = theRunInformationTable.GetValueList();
  for ( Tsize_t i = 0; i < valuelist.size(); i ++ )
    valuelist[ i ] = "";
  theRunInformationTable.SetValueList( valuelist );
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Update()
{
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Initialize()
{
  theRunInformationTable.Clear();
  return( theStatus = tStatusSuccess );  
}
