// ============================================================================
//  $Id: TSoftwareScalerModule.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSoftwareScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareScalerModule::TSoftwareScalerModule( Tint nchannel )
  : TSoftwareModule( nchannel ), theChannel( nchannel, 0 )
{;}

TSoftwareScalerModule::TSoftwareScalerModule( const TSoftwareScalerModule& right )
  : TSoftwareModule( right ), theChannel( right.theChannel )
{;}

TSoftwareScalerModule::~TSoftwareScalerModule()
{;}

Tvoid TSoftwareScalerModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TDataElement element( &theChannel[ i ], tTypeInt, itostr( i ), 1 );
    ((TDataElementList*)(&segment)) -> push_back( element );
  }
  return;
}

Tvoid TSoftwareScalerModule::FillData( const TDataElement& element )
{
  Tint ch = atoi( element.GetID().c_str() );
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TSoftwareScalerModule::FillData: invalid ID" << Tendl;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    ((TDataElement*)(&element)) -> FillData( &theChannel[ ch ], tTypeInt, 1 );
  }
  return;
}

const TSoftwareScalerModule& TSoftwareScalerModule::operator=( const TSoftwareScalerModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theChannel = right.theChannel;
  return( *this );
}

Tbool TSoftwareScalerModule::operator==( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theChannel == right.theChannel );
  return( ret );
}

Tbool TSoftwareScalerModule::operator!=( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( theChannel != right.theChannel );
  return( ret );
}
