// ============================================================================
//  $Id: TVmeDaughterBoardMemoryModule.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( Toff_t offset, Tint mapsize, Tint nsamples )
  : TVmeModule( 1, offset, mapsize, tA32D32 ),
    //theNumberOfSampling( nsamples / 2 ) // <- probrem
    theNumberOfSampling( nsamples )
{;}

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right )
  : TVmeModule( right ),
    theNumberOfSampling( right.theNumberOfSampling )
{;}

TVmeDaughterBoardMemoryModule::~TVmeDaughterBoardMemoryModule()
{;}

const TVmeDaughterBoardMemoryModule& TVmeDaughterBoardMemoryModule::operator=( const TVmeDaughterBoardMemoryModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return( *this );
}

Tbool TVmeDaughterBoardMemoryModule::operator==( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return( ret );
}

Tbool TVmeDaughterBoardMemoryModule::operator!=( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theNumberOfSampling != right.theNumberOfSampling );
  return( ret );
}

Tint TVmeDaughterBoardMemoryModule::Clear()
{
  Tlong* membase = (Tlong*)theBaseAddress;
  for ( Tint i = 0; i < theNumberOfSampling; i ++ )
    membase[ i ] = 0;
  return( theStatus = tStatusSuccess );
}

Tint TVmeDaughterBoardMemoryModule::Update()
{
  return( Clear() );
}

Tint TVmeDaughterBoardMemoryModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Tlong* membase = (Tlong*)theBaseAddress;
    TUshort* data = new TUshort[ theNumberOfSampling ];

    for ( Tint j = 0; j < theNumberOfSampling; j ++ ) {
      data[ j ] = modifyData( (Tshort)( *membase & 0x0000ffff ) );
      membase ++;
    }

    TDataElement element( data, tTypeUnsignedShort, itostr( i ), theNumberOfSampling );
    delete [] data;
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }

  return;
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( const TDataElement& element )
{
  Tlong* membase = (Tlong*)theBaseAddress;
  TUshort* data = new TUshort[ theNumberOfSampling ];

  for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
    data[ i ] = modifyData( (Tshort)( *membase & 0x0000ffff ) );
    membase ++;
  }

  Tint ch = atoi( element.GetID().c_str() );
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TVmeDaughterBoardMemoryModule::FillData: invalid ID" << Tendl;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    ((TDataElement*)(&element)) -> FillData( data, tTypeUnsignedShort, theNumberOfSampling );
  }

  delete [] data;

  return;
}
