// ============================================================================
//  $Id: TVmeRpv130Module.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TVMERPV130MODULE_HH
#define __TVMERPV130MODULE_HH

#include "globals.h"
#include "TVmeModule.hh"

class TDataSegment;
class TDataElement;
class TVmeDaughterBoardMemoryModule;

class TVmeRpv130Module
  : public TVmeModule
{

  private:
    enum
    {
      LATCH1 = 0x00,
      LATCH2 = 0x02,
      RSFF = 0x04,
      THROUGH = 0x06,
      PULSE = 0x08,
      LEVEL = 0x0a,
      CSR1 = 0x0c,
      CSR2 = 0x0e
    };

  public:
    enum
    {
      tReadoutWithLatch1,
      tReadoutWithLatch2,
      tReadoutWithRSFF,
      tReadoutWithThrough
    };

  private:
    Tint theReadoutMode;
    Tint theLevelStatus;

  public:
    // should be 1 channel module
    TVmeRpv130Module( Toff_t offset, Tint mapsize = 0x1000, Tint nch = 8 );
    TVmeRpv130Module( const TVmeRpv130Module& right );
    ~TVmeRpv130Module();

  public:
    Tint GetReadoutMode() const;
    Tvoid SetReadoutMode( Tint readmode );
    Tint GetLevelStatus() const;
    Tvoid SetLevelStatus( Tint status );

  public:
    const TVmeRpv130Module& operator=( const TVmeRpv130Module& right );
    Tbool operator==( const TVmeRpv130Module& right ) const;
    Tbool operator!=( const TVmeRpv130Module& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  public:
    Tvoid Pulse();
    Tvoid Pulse( Tint channel );
    Tvoid LevelUp();
    Tvoid LevelUp( Tint channel );
    Tvoid LevelDown();
    Tvoid LevelDown( Tint channel );
    Tvoid Enable();
    Tvoid Disable();
    TUshort Read();
    TUshort Read( Tint channel );

};

inline Tint TVmeRpv130Module::GetReadoutMode() const
{
  return( theReadoutMode );
}

inline Tvoid TVmeRpv130Module::SetReadoutMode( Tint readmode )
{
  theReadoutMode = readmode;
  return;
}

inline Tint TVmeRpv130Module::GetLevelStatus() const
{
  return( theLevelStatus );
}

inline Tvoid TVmeRpv130Module::SetLevelStatus( Tint status )
{
  status &= 0x00ff;
  theLevelStatus = status;
  return;
}

#endif
