// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTDEFINITION_HH
#define __TREADOUTDEFINITION_HH

#include "globals.h"

class TReadoutDefinition
{

  protected:
    Tstring theID;

  public:
    TReadoutDefinition( const Tstring& id );
    TReadoutDefinition( const TReadoutDefinition& right );

  protected:
    virtual ~TReadoutDefinition();

  public:
    virtual const TReadoutDefinition& operator=( const TReadoutDefinition& right );
    virtual Tbool operator==( const TReadoutDefinition& right ) const;
    virtual Tbool operator!=( const TReadoutDefinition& right ) const;

  public:
    const Tstring& GetID() const;
    Tvoid SetID( const Tstring& id );

};

inline const Tstring& TReadoutDefinition::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutDefinition::SetID( const Tstring& id )
{
  theID = id;
  return;
}

#endif
