// ============================================================================
//  $Id: TReadoutElement.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TREADOUTELEMENT_HH
#define __TREADOUTELEMENT_HH

#include "globals.h"
#include "TReadoutDefinition.hh"

class TModule;
class TDataElement;

class TReadoutElement
  : public TReadoutDefinition
{

  private:
    TModule* theModule;

  public:
    TReadoutElement( TModule* module, const Tstring& id = TunknownID );
    TReadoutElement( const TReadoutElement& right );
    ~TReadoutElement();

  public:
    const TReadoutElement& operator=( const TReadoutElement& right );
    Tbool operator==( const TReadoutElement& right ) const;
    Tbool operator!=( const TReadoutElement& right ) const;

  public:
    TDataElement ReadData();

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

};

inline TModule* TReadoutElement::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutElement::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
