// ============================================================================
//  $Id: TReadoutList.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutList::TReadoutList( const Tstring& id )
  : TReadoutDefinition( id ), TReadoutSectionList()
{;}

TReadoutList::TReadoutList( const TReadoutList& right )
  : TReadoutDefinition( right ), TReadoutSectionList( right )
{;}

TReadoutList::~TReadoutList()
{;}

TDataRecord TReadoutList::ReadData()
{
  TDataRecord record( theID );

  for ( Tsize_t i = 0; i < size(); i ++ )
    record.push_back( ( (*this)[ i ] ).ReadData() );

  return( record );
}

const TReadoutList& TReadoutList::operator=( const TReadoutList& right )
{
  *( (TReadoutDefinition*)this ) = *( (TReadoutDefinition*)(&right) );
  *( (TReadoutSectionList*)this ) = *( (TReadoutSectionList*)(&right) );
  return( *this );
}

Tbool TReadoutList::operator==( const TReadoutList& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutDefinition*)this ) == *( (TReadoutDefinition*)(&right) ) );
  ret &= ( *( (TReadoutSectionList*)this ) == *( (TReadoutSectionList*)(&right) ) );
  return( ret );
}

Tbool TReadoutList::operator!=( const TReadoutList& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutDefinition*)this ) != *( (TReadoutDefinition*)(&right) ) );
  ret |= ( *( (TReadoutSectionList*)this ) != *( (TReadoutSectionList*)(&right) ) );
  return( ret );
}
