// ============================================================================
//  $Id: TRunInformationTable.hh,v 1.2 2002/12/08 21:21:42 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TRUNINFORMATIONTABLE_HH
#define __TRUNINFORMATIONTABLE_HH

#include "globals.h"

class TOutputHtmlFileStream;

class TRunInformationTable
{

  public:
    enum { tNotFound = -1 };

  private:
    TstringList theItemList;
    TstringList theValueList;

  public:
    TRunInformationTable();
    TRunInformationTable( const TstringList& itemlist );
    TRunInformationTable( const TstringList& itemlist, const TstringList& valuelist );
    TRunInformationTable( const TRunInformationTable& right );
    ~TRunInformationTable();

  public:
    const TRunInformationTable& operator=( const TRunInformationTable& right );
    Tbool operator==( const TRunInformationTable& right ) const;
    Tbool operator!=( const TRunInformationTable& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TRunInformationTable& right );
    friend TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& tos, const TRunInformationTable& right );

  public:
    const TstringList& GetItemList() const;
    const TstringList& GetValueList() const;
    Tvoid SetItemList( const TstringList& itemlist );
    Tvoid SetValueList( const TstringList& valuelist );

  public:
    Tint GetNumberOfRows() const;
    Tvoid AddRow( const Tstring& item, const Tstring& value );
    Tvoid SetRow( const Tstring& item, const Tstring& value );
    Tstring GetValue( const Tstring& item ) const;
    Tstring GetValue( Tint nrow ) const;
    Tstring GetItem( const Tstring& value ) const;
    Tstring GetItem( Tint nrow ) const;
    Tint FindItem( const Tstring& item ) const;
    Tint FindValue( const Tstring& value ) const;
    Tbool HasItem( const Tstring& item ) const;
    Tvoid Remove( const Tstring& item );
    Tvoid Clear();

};

inline const TstringList& TRunInformationTable::GetItemList() const
{
  return( theItemList );
}

inline const TstringList& TRunInformationTable::GetValueList() const
{
  return( theValueList );
}

inline Tvoid TRunInformationTable::SetItemList( const TstringList& itemlist )
{
  theItemList = itemlist;
  return;
}

inline Tvoid TRunInformationTable::SetValueList( const TstringList& valuelist )
{
  theValueList = valuelist;
  return;
}

#endif
