// ============================================================================
//  $Id: fileInput.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  TstringList findtag;
  findtag.push_back( "This section is for software modules." );
  findtag.push_back( "ADC" );
  findtag.push_back( "5" );

  TDataRecord record;
  TDataElement element;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    if ( record.FindDataElement( findtag, element ) ) {
      Tcout << element << Tendl;
    } else {
      Tcerr << "Keyword: ";
      for ( Tsize_t i = 0; i < findtag.size(); i ++ ) {
	Tcerr << Twquote << findtag[ i ] << Twquote << ", ";
      }
      Tcerr << "not found." << Tendl;
    }
  }

  delete ifile;
  return( 0 );
}
