// ============================================================================
//  $Id: BtEventAction.cc,v 1.6 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TCamacInterruptRegisterModule.hh"
#include "TCamacOutputRegisterModule.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "BtEventAction.hh"
#include "BtRunAction.hh"
#include "BtRunSummary.hh"

BtEventAction::BtEventAction()
{;}

BtEventAction::~BtEventAction()
{;}

TReadoutList* BtEventAction::WaitEvent()
{
  // define trigger.
  enum { nosignal = 0x0000, event = 0x0001, scaler = 0x0002, both = 0x0003 };

  TCamacInterruptRegisterModule* ir =
    (TCamacInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );

  Tbool trigger = Tfalse;
  Tint trgtype = nosignal;
  do {
    ir -> ReadInterruptRegister();
    if ( ir -> GetCamacData() != nosignal ) {
      trigger = Ttrue;
      trgtype = ir -> GetCamacData();
      break;
    }
  } while ( trigger == Tfalse );

  if ( trgtype == event || trgtype == both ) {
    return( theReadoutBook -> GetReadoutList( "CSI EVENT" ) );
  } else if ( trgtype == scaler ) {
    return( theReadoutBook -> GetReadoutList( "SCALER EVENT" ) );
  } else {
    Tcerr << "unnown trigger, exception occured." << Tendl;
    Tcerr << "check the hardware." << Tendl;
    return( 0 );
  }

}

Tvoid BtEventAction::BeginOfEventAction( TEvent& anEvent )
{
  TCamacOutputRegisterModule* org =
    (TCamacOutputRegisterModule*)( theCrate -> GetModule( "Output Register" ) );
  org -> Pulse( 0x0001 );  // bit pattern
  return;
}

Tvoid BtEventAction::EndOfEventAction( TEvent& anEvent )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TDataRecord record = anEvent.GetDataRecord();
  *ofile << record;

  Tstring evttype = record.GetID();

  if ( evttype == "CSI EVENT" ) {
    fillCsIEventInformation( record );
    theCrate -> Update( "csi event" );
  } else if ( evttype == "SCALER EVENT" ) {
    fillScalerEventInformation( record );
    theCrate -> Update( "scaler event" );
  } else {
    Tstring head = "BtEventAction::EndOfEventAction: ";
    Tcerr << head << "unkown trigger." << Tendl;
    Tcerr << record << Tendl;
    Tcerr << head << "confuse." << Tendl;    
  }

  return;
}

Tvoid BtEventAction::fillCsIEventInformation( const TDataRecord& record )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  BtRunSummary* summary = action -> GetRunSummary();
  
  Tint ncsi = summary -> GetNumberOfCsIEvents();
  Tint nevents = summary -> GetNumberOfAllEvents();
  summary -> SetNumberOfCsIEvents( ++ ncsi );
  summary -> SetNumberOfAllEvents( ++ nevents );

  return;
}

Tvoid BtEventAction::fillScalerEventInformation( const TDataRecord& record )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  BtRunSummary* summary = action -> GetRunSummary();

  Tint nscaler = summary -> GetNumberOfScalerEvents();
  Tint nevents = summary -> GetNumberOfAllEvents();

  static Tstring findtag[ 2 ] = { "EVENT", "SCALER" };
  TDataSegment scaler;
  record.FindDataSegment( findtag, scaler );

  for ( Tsize_t i = 0; i < scaler.size(); i ++ ) {
    TUint databuf = *( scaler[ i ].GetUnsignedIntData() );
    summary -> AddAccumulatedScaler( i, (Tint)databuf );
  }

  summary -> SetNumberOfScalerEvents( ++ nscaler );
  summary -> SetNumberOfAllEvents( ++ nevents );

  return;
}
