// ============================================================================
//  $Id: DummyCrateDefinition.cc,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCrate.hh"
#include "DummyCrateDefinition.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareFlashAdcModule.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareDataFileModule.hh"
#include "TRunInformationTable.hh"

DummyCrateDefinition::DummyCrateDefinition()
  : TCrateDefinition()
{;}

DummyCrateDefinition::~DummyCrateDefinition()
{;}

TCrate* DummyCrateDefinition::Define()
{
  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "OPERATOR" );
  itemlist.push_back( "BEAM ENERGY" );
  itemlist.push_back( "RUN TYPE" );
  itemlist.push_back( "COMMENT" );
  TstringList valuelist;
  valuelist.clear();
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  TRunInformationTable table = TRunInformationTable( itemlist, valuelist );

  TCrate* crate = new TCrate();

  crate -> AddModule( new TSoftwareScalerModule( 1 ), "Run ID", "run begin initialize" );
  crate -> AddModule( new TSoftwareScalerModule( 1 ), "Event ID", "run begin initialize" );
  crate -> AddModule( new TSoftwareRunInformationModule( table ), "Run Information" );
  crate -> AddModule( new TSoftwareClockModule( 1 ), "Clock", "run begin initialize" );
  crate -> AddModule( new TSoftwareTimerModule( Tusec, 1 ), "Timer", "run begin initialize" );
  crate -> AddModule( new TSoftwareFlashAdcModule(), "Flash ADC", "run begin initialize" );
  crate -> AddModule( new TSoftwareAdcModule(), "ADC", "run begin initialize" );
  crate -> AddModule( new TSoftwareInterruptRegisterModule( 1 ), "Interrupt Register", "run begin initialize" );
  crate -> AddModule( new TSoftwareDataFileModule( "sample.g4dat", 2 ), "Geant4", "run begin initialize" );

  return( crate );
}
