// ============================================================================
//  $Id: DummyRunAction.cc,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRun.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TOutputObjectFile.hh"
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TCrate.hh"

#include "DummyRunAction.hh"

DummyRunAction::DummyRunAction()
  : theOutputFile( 0 ), theOutputHtml(), theRunSummary()
{;}

DummyRunAction::~DummyRunAction()
{;}

Tvoid DummyRunAction::BeginOfRunAction( TRun& aRun )
{
  Tint runid = aRun.GetRunID();
  Tstring filename = "run";
  Tstring runidstr = aRun.GetRunIDofString();
  if ( runid < 10 ) {
    filename += "00";
  } else if ( runid < 100 ) {
    filename += "0";
  }
  Tstring drecfile = filename + runidstr + ".drec";
  Tstring htmlfile = filename + runidstr + ".html";


  theCrate -> Initialize( "run begin initialize" );
  TSoftwareScalerModule* scaler = (TSoftwareScalerModule*)( theCrate -> GetModule( "Run ID" ) );
  scaler -> SetData( 0, runid );

  theOutputFile = new TOutputObjectFile( drecfile );
  TDataRecord record = theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> ReadData();
  *theOutputFile << record;

  theOutputHtml.Open( htmlfile );
  theRunSummary.Initialize();
  fillRunBeginInformation( record );

  return;
}

Tvoid DummyRunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> ReadData();
  *theOutputFile << record;

  fillRunEndInformation( record );
  fillHtmlFile();
  theOutputHtml.Close();

  delete theOutputFile;
  theOutputFile = 0;
  return;
}

Tvoid DummyRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}

Tvoid DummyRunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "Run Information", "Run ID", "0" };
  static Tstring clockset[ 3 ] = { "Run Information", "Clock", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary.SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary.SetRunID( *( runid.GetIntData() ) );
  theRunSummary.SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid DummyRunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "Run Information", "Clock", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );

  theRunSummary.SetRunInformationTable( theRunManager -> GetRunInformationModule() -> GetRunInformationTable() );
  theRunSummary.SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary.SetRecordSize( theOutputFile -> GetTotalDataSize() );
  theRunSummary.SetNumberOfEvents( theEventManager -> GetNumberOfEvents() );

  return;
}

Tvoid DummyRunAction::fillHtmlFile()
{
  TRunInformationTable table = theRunSummary.GenerateRunSummaryTable();
  Tstring title = "Run Summary #" + ( theRunManager -> GetRun() ).GetRunIDofString();
  theOutputHtml.SetTitle( title );
  theOutputHtml.SetInformationTable( table );

  theOutputHtml << TOutputHtmlFileStream::tHeader << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tTable << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tFooter << Tendl;

  return;
}
