// ============================================================================
//  $Id: DummyRunAction.hh,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __DUMMYRUNACTION_HH
#define __DUMMYRUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"
#include "DummyRunSummary.hh"

class TRun;
class TOutputObjectFile;
class TDataRecord;

class DummyRunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TOutputHtmlFileStream theOutputHtml;
    DummyRunSummary theRunSummary;

  public:
    DummyRunAction();
    ~DummyRunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    TOutputHtmlFileStream& GetOutputHtml();
    const DummyRunSummary& GetRunSummary() const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* DummyRunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline TOutputHtmlFileStream& DummyRunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

inline const DummyRunSummary& DummyRunAction::GetRunSummary() const
{
  return( theRunSummary );
}

#endif
