// ============================================================================
//  $Id: TAnalysisStatusTable.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TANALYSISSTATUSTABLE_HH
#define __TANALYSISSTATUSTABLE_HH

#include "Tglobals.h"
#include "TAnalysisStatus.hh"

typedef Tvector<TAnalysisStatus> TAnalysisStatusList;

class TAnalysisStatusTable
  : TAnalysisStatusList
{

  public:
    enum { tNotFound = -1 };

  public:
    TAnalysisStatusTable();
    ~TAnalysisStatusTable();

  public:
    friend Tostream& operator<<( Tostream& tos, const TAnalysisStatusTable& right );

  public:
    Tvoid AddAnalysisStatus( const TAnalysisStatus& status );
    Tvoid RemoveAnalysisStatus( const Tstring& id );
    Tint FindAnalysisStatus( const Tstring& id ) const;
    Tvoid Clear();
    Tstatus_t GetStatus( const Tstring& id ) const;
    Tvoid SetStatus( const Tstring& id, Tstatus_t status );
    Tobject_t GetObjectType( const Tstring& id ) const;
    Tstring GetID( const Tstring& id ) const;
    Tstring GetDrawableObjectID( const Tstring& id ) const;
    Tstring GetCanvasID( const Tstring& id ) const;
    Tthread_t* GetThreadID( const Tstring& id );
    Tvoid SetThreadID( const Tstring& id, Tthread_t thread );
    Tbool HasStatus( const Tstring& id ) const;

};

#endif
