// ============================================================================
//  $Id: TUserInterface.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TUserInterface.hh"
#include "TCommand.hh"

TUserInterface::TUserInterface( const Tstring& history )
  : theCommandList( 0 ), theCommandListCapacity( 1 ), 
    theNumberOfCommands( 0 ), theCommandIndex( 0 ),
    theNumberOfColumns( 0 ), theNumberOfLines( 0 ),
    theCurrentWorkingDirectory( Tslash )
{
  theHistoryFileStream.open( history.c_str(), Tout );
  if ( !( theHistoryFileStream.good() ) ) {
    Tcerr << "TUserInterface::TUserInterface: fail to open a file ";
    Tcerr << history << "." << Tendl;
  }
  allocate( theCommandListCapacity );

  theNumberOfColumns = tigetnum( "cols" );
  theNumberOfLines = tigetnum( "lines" );

  //test
  //   initscr();
  //   refresh();
  //   move( 0, 0 );
}

TUserInterface::~TUserInterface()
{
  free();
  theHistoryFileStream.close();
  //initscr();
  //refresh();
  //move( 0, 0 );
}

Tint TUserInterface::AddCommand( TCommand* command )
{
  const Tstring& strbuf = command -> GetCommandName();
  for ( Tint i = 0; i < theNumberOfCommands; i ++ ) {
    if ( theCommandList[ i ] -> GetCommandName() == strbuf ) {
      Tcerr << "TUserInterface::AddCommand: already exist command identified as " << strbuf << "." << Tendl;
      return( theNumberOfCommands );
    }
  }
  if ( theNumberOfCommands >= theCommandListCapacity )
    ResizeCommandList( theCommandListCapacity *= 2 );
  theCommandList[ theNumberOfCommands ] = command;
  theNumberOfCommands ++;
  theCommandIndex = theNumberOfCommands - 1;
  return( theNumberOfCommands );
}

Tint TUserInterface::RemoveCommand( Tint index )
{
  Tstring head = "TUserInterface::RemoveCommand: ";
  if ( index < 0 || index >= theNumberOfCommands ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return( theNumberOfCommands );
  }
  theCommandIndex = index;
  Tstring name = theCommandList[ theCommandIndex ] -> GetCommandName();
  delete theCommandList[ theCommandIndex ];
  Tcout << head << name << " command was deleted." << Tendl;
  for ( Tint i = theCommandIndex; i < theNumberOfCommands; i ++ )
    theCommandList[ i ] = theCommandList[ i + 1 ];
  theNumberOfCommands --;
  return( theNumberOfCommands );
}

Tvoid TUserInterface::ClearCommandList()
{
  Tstring head = "TUserInterface::ClearCommandList: ";
  for ( Tint i = 0; i < theNumberOfCommands; i ++ ) {
    if ( theCommandList[ i ] ) {
      Tstring name = theCommandList[ i ] -> GetCommandName();
      delete theCommandList[ i ];
      Tcout << head << name << " command was deleted." << Tendl;
    }
  }
  theNumberOfCommands = 0;
  theCommandIndex = 0;
  return;
}

Tbool TUserInterface::ResizeCommandList( Tint capacity )
{
  if ( theNumberOfCommands >= capacity ) {
    Tcerr << "TUserInterface::ResizeCommandList: invalid capacity" << Tendl;
    return( Tfalse );
  }
  theCommandListCapacity = capacity;
  TCommand** newcommands = new TCommand* [ theCommandListCapacity ];
  for ( Tint i = 0; i < theNumberOfCommands; i ++ )
    newcommands[ i ] = theCommandList[ i ];
  delete [] theCommandList;
  theCommandList = newcommands;
  theCommandIndex = theNumberOfCommands - 1;
  return( Ttrue );
}

TCommand* TUserInterface::NextCommand()
{
  if ( theCommandIndex < 0 || theCommandIndex >= theNumberOfCommands )
    return( 0 );
  return( theCommandList[ theCommandIndex ++ ] );
}

TCommand* TUserInterface::FindCommand( const Tstring& command )
{
  Tint indexbuf = theCommandIndex;
  theCommandIndex = 0;
  TCommand* com = 0;
  while ( ( com = NextCommand() ) ) {
    if ( com -> GetCommandName() == command ) {
      theCommandIndex = indexbuf;
      return( com );
    }
  }
  theCommandIndex = indexbuf;
  return( 0 );
}

TCommand* TUserInterface::GetCommand( Tint index )
{
  if ( index < 0 || index >= theNumberOfCommands ) {
    Tcerr << "TUserInterface::GetCommand: invalid index" << Tendl;
    return( 0 );
  }
  theCommandIndex = index;
  return( theCommandList[ theCommandIndex ] );
}

TCommand* TUserInterface::GetCommand()
{
  return( GetCommand( theCommandIndex ) );
}

Tvoid TUserInterface::ExecuteCommand( const Tstring& command, const TstringList& arguments )
{
  TCommand* com = FindCommand( command );
  if ( com != 0 )
    com -> Execute( arguments );
  return;
}

Tvoid TUserInterface::ExecuteCommand( const Tstring& command )
{
  TstringList args;
  args.clear();
  ExecuteCommand( command, args );
  return;
}

Tvoid TUserInterface::free()
{
  Tstring head = "TUserInterface::free: ";
  for ( Tint i = 0; i < theNumberOfCommands; i ++ ) {
    if ( theCommandList[ i ] ) {
      Tstring name = theCommandList[ i ] -> GetCommandName();
      delete theCommandList[ i ];
      Tcout << head << name << " command was deleted." << Tendl;
    }
  }
  delete [] theCommandList;
  theCommandListCapacity = 0;
  theNumberOfCommands = 0;
  theCommandIndex = 0;
  return;
}

Tvoid TUserInterface::allocate( Tint capacity )
{
  theCommandListCapacity = capacity;
  theCommandList = new TCommand* [ theCommandListCapacity ];
  return;
}

Tvoid TUserInterface::NotFoundCommand( const Tstring& commandname ) const
{
  return;
}

Tint TUserInterface::GetCurrentWorkingDirectoryLevel() const
{
  return( 1 );
}

Tbool TUserInterface::HasDirecotryInThisDirecotry( const Tstring& directory ) const
{
  return( Ttrue );
}

