// ============================================================================
//  $Id: TCamacInterruptRegisterModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacInterruptRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacInterruptRegisterModule::TCamacInterruptRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacInterruptRegisterModule::TCamacInterruptRegisterModule( const TCamacInterruptRegisterModule& right )
  : TCamacModule( right )
{;}

TCamacInterruptRegisterModule::~TCamacInterruptRegisterModule()
{;}

const TCamacInterruptRegisterModule& TCamacInterruptRegisterModule::operator=( const TCamacInterruptRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacInterruptRegisterModule::operator==( const TCamacInterruptRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacInterruptRegisterModule::operator!=( const TCamacInterruptRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacInterruptRegisterModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TCamacInterruptRegisterModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else if ( channel == 0 ) {
    ReadInterruptRegister();
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  } else if ( channel == 1 ) {
    ReadInterruptMaskRegister();
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  } else {
    // status filled
    element.FillData( &theStatus, tTypeInt, 1 );
  }
  return;
}

Tint TCamacInterruptRegisterModule::Initialize()
{
  Clear();
  ClearInterruptMaskRegister();
  DisableInterrupt();
  return( DisableInterruptOutput() );
}

Tint TCamacInterruptRegisterModule::ReadInterruptRegister()
{
  // in case of Read(), disable LAM after execution.
  return( execute( 1, tCamacRead ) );
}

Tint TCamacInterruptRegisterModule::ReadInterruptMaskRegister()
{
  return( execute( 0, 1 ) );
}

Tint TCamacInterruptRegisterModule::ClearInterruptMaskRegister()
{
  return( execute( 0, 11 ) );
}

Tint TCamacInterruptRegisterModule::WriteInterruptMaskRegister( Tint data )
{
  theCamacData = (TUint)data;
  return( execute( 0, 17 ) );
}

Tint TCamacInterruptRegisterModule::ClearInterruptRegister()
{
  // enable LAM execution
  return( execute( 0, 21 ) );
}

Tint TCamacInterruptRegisterModule::DisableInterruptOutput()
{
  return( execute( 0, tCamacEnableInterrupt ) );
}

Tint TCamacInterruptRegisterModule::EnableInterruptOutput()
{
  return( execute( 0, tCamacDisableInterrupt ) );
}
