// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TCrate.hh"
#include "TModule.hh"
#include "TCamacCrateController.hh"

TCrate::TCrate()
  : theModuleList( 0 ), theModuleSpecifiedTable(),
    theModuleListCapacity( 1 ), theNumberOfModules( 0 ), 
    theModuleIndex( 0 ), theCamacCrateController( 0 )
{
  theModuleSpecifiedTable.clear();
  allocate( theModuleListCapacity );
}

TCrate::~TCrate()
{
  free();
}

Tint TCrate::AddModule( TModule* module, const Tstring& id, const TstringList& groups )
{
  if ( FindModule( id ) != 0 ) {
    Tcerr << "TCrate::AddModule: already exist Module identified as " << id << "." << Tendl;
      return( theNumberOfModules );
  }

  if ( theNumberOfModules >= theModuleListCapacity )
    ResizeModuleList( theModuleListCapacity *= 2 );
  theModuleList[ theNumberOfModules ] = module;
  theNumberOfModules ++;
  theModuleIndex = theNumberOfModules - 1;

  TModuleSpecified spec( theModuleIndex - 1, id, groups );
  theModuleSpecifiedTable.push_back( spec );

  return( theNumberOfModules );
}

Tint TCrate::AddModule( TModule* module, const Tstring& id, const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  return( AddModule( module, id, groups ) );
}

Tint TCrate::RemoveModule( Tint index )
{
  Tstring head = "TCrate::RemoveModule: ";
  if ( index < 0 || index >= theNumberOfModules ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return( theNumberOfModules );
  }
  theModuleIndex = index;
  Tstring id = theModuleSpecifiedTable[ theModuleIndex ].GetModuleID();
  delete theModuleList[ theModuleIndex ];
  Tcout << head << id << " module was removed." << Tendl;
  for ( Tint i = theModuleIndex; i < theNumberOfModules; i ++ )
    theModuleList[ i ] = theModuleList[ i + 1 ];
  theNumberOfModules --;
  theModuleSpecifiedTable.erase( theModuleSpecifiedTable.begin() + theModuleIndex );
  return( theNumberOfModules );
}

Tint TCrate::RemoveModule( const Tstring& id )
{
  for ( Tsize_t i = 0; i < theModuleSpecifiedTable.size(); i ++ ) {
    if ( theModuleSpecifiedTable[ i ].GetModuleID() == id ) {
      Tint index = theModuleSpecifiedTable[ i ].GetModuleIndex();
      return( RemoveModule( index ) );
    }
  }
  return( theNumberOfModules );
}

Tint TCrate::RemoveModule( const TstringList& groups )
{
  for ( Tsize_t i = 0; i < theModuleSpecifiedTable.size(); i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      Tint index = theModuleSpecifiedTable[ i ].GetModuleIndex();
      RemoveModule( index );
    }
  }
  return( theNumberOfModules );
}

Tvoid TCrate::ClearModuleList()
{
  Tstring head = "TCrate::ClearModuleList: ";
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      Tstring id = theModuleSpecifiedTable[ i ].GetModuleID();
      delete theModuleList[ i ];
      Tcout << head << id << " module was removed." << Tendl;;
    }
  }

  theModuleSpecifiedTable.clear();

  RemoveCamacCrateController();

  theNumberOfModules = 0;
  theModuleIndex = 0;
  return;
}

Tbool TCrate::ResizeModuleList( Tint capacity )
{
  if ( theNumberOfModules >= capacity ) {
    Tcerr << "TCrate::ResizeModuleList: invalid capacity" << Tendl;
    return( Tfalse );
  }
  theModuleListCapacity = capacity;
  TModule** newModules = new TModule* [ theModuleListCapacity ];
  for ( Tint i = 0; i < theNumberOfModules; i ++ )
    newModules[ i ] = theModuleList[ i ];
  delete [] theModuleList;
  theModuleList = newModules;
  theModuleIndex = theNumberOfModules - 1;
  return( Ttrue );
}

TModule* TCrate::NextModule()
{
  if ( theModuleIndex < 0 || theModuleIndex >= theNumberOfModules )
    return( 0 );
  return( theModuleList[ theModuleIndex ++ ] );
}

TModule* TCrate::FindModule( const Tstring& id )
{
  for ( Tsize_t index = 0; index < theModuleSpecifiedTable.size(); index ++ ) {
    if ( theModuleSpecifiedTable[ index ].GetModuleID() == id ) {
      return( GetModule( index ) );
    }
  }
  return( 0 );
}

TModule* TCrate::GetModule( Tint index )
{
  if ( index < 0 || index >= theNumberOfModules ) {
    Tcerr << "TCrate::GetModule: invalid index" << Tendl;
    return( 0 );
  }
  theModuleIndex = index;
  return( theModuleList[ theModuleIndex ] );
}

TModule* TCrate::GetModule( const Tstring& id )
{
  return( FindModule( id ) );
}

TModule* TCrate::GetModule()
{
  return( GetModule( theModuleIndex ) );
}

Tvoid TCrate::Clear( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Clear();
    }
  }
  return;
}

Tvoid TCrate::Clear( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Clear( groups );
  return;
}

Tvoid TCrate::Update( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Update();
    }
  }
  return;
}

Tvoid TCrate::Update( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Update( groups );
  return;
}

Tvoid TCrate::Initialize( const TstringList& groups )
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleSpecifiedTable[ i ].IsSameGroup( groups ) ) {
      theModuleList[ i ] -> Initialize();
    }
  }
  return;
}

Tvoid TCrate::Initialize( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Initialize( groups );
  return;
}

Tvoid TCrate::ClearAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Clear();
    }
  }
  return;
}

Tvoid TCrate::UpdateAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Update();
    }
  }
  return;
}

Tvoid TCrate::InitializeAllModules()
{
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      theModuleList[ i ] -> Initialize();
    }
  }
  return;
}

Tvoid TCrate::ClearModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Clear();
  }
  return;
}

Tvoid TCrate::UpdateModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Update();
  }
  return;
}

Tvoid TCrate::InitializeModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Initialize();
  }
  return;
}

Tvoid TCrate::InstallCamacCrateController( TCamacCrateController* cratectl )
{
  static const Tstring head = "TCrate::SetCamacCrateController: ";
  if ( theCamacCrateController == 0 ) {
    theCamacCrateController = cratectl;
  } else {
    Tcerr << head << "CAMAC CrateController has already been installed." << Tendl;
  }
  return;
}

Tvoid TCrate::RemoveCamacCrateController()
{
  static const Tstring head = "TCrate::RemoveCamacCrateController: ";
  if ( theCamacCrateController ) {
    delete theCamacCrateController;
    theCamacCrateController = 0;
    Tcout << head << "crate controller was removed." << Tendl;
  }
  return;
}

Tvoid TCrate::free()
{
  static const Tstring head = "TCrate::free: ";
  for ( Tint i = 0; i < theNumberOfModules; i ++ ) {
    if ( theModuleList[ i ] ) {
      Tstring id = theModuleSpecifiedTable[ i ].GetModuleID();
      delete theModuleList[ i ];
      Tcout << head << id << " module was removed." << Tendl;
    }
  }
  delete [] theModuleList;

  theModuleSpecifiedTable.clear();

  RemoveCamacCrateController();

  theModuleListCapacity = 0;
  theNumberOfModules = 0;
  theModuleIndex = 0;
  return;
}

Tvoid TCrate::allocate( Tint capacity )
{
  theModuleListCapacity = capacity;
  theModuleList = new TModule* [ theModuleListCapacity ];
  return;
}
