// ============================================================================
//  $Id: TSoftwareRunInformationModule.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSOFTWARERUNINFORMATIONMODULE_HH
#define __TSOFTWARERUNINFORMATIONMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"
#include "TRunInformationTable.hh"

class TDataSegment;
class TDataElement;

class TSoftwareRunInformationModule
  : public TSoftwareModule
{

  private:
    TRunInformationTable theRunInformationTable;

  public:
    TSoftwareRunInformationModule();
    TSoftwareRunInformationModule( const TRunInformationTable& table );
    TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right );
    ~TSoftwareRunInformationModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSoftwareRunInformationModule& operator=( const TSoftwareRunInformationModule& right );
    Tbool operator==( const TSoftwareRunInformationModule& right ) const;
    Tbool operator!=( const TSoftwareRunInformationModule& right ) const;

  public:
    TRunInformationTable& GetRunInformationTable();
    const TRunInformationTable& GetRunInformationTable() const;
    Tvoid SetRunInformationTable( const TRunInformationTable& table );

};

inline TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable()
{
  return( theRunInformationTable );
}

inline const TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline Tvoid TSoftwareRunInformationModule::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return;
}

#endif
