// ============================================================================
//  $Id: TVmeDaughterBoardMemoryModule.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TVMEDAUGHTERBOARDMEMORYMODULE_HH
#define __TVMEDAUGHTERBOARDMEMORYMODULE_HH

#include "Tglobals.h"
#include "TVmeModule.hh"

class TDataSegment;
class TDataElement;

class TVmeDaughterBoardMemoryModule
  : public TVmeModule
{

  private:
    Tint theNumberOfSampling;

  public:
    TVmeDaughterBoardMemoryModule( Toff_t offset, Tint mapsize, Tint nsamples, Tint nch );
    TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right );
    ~TVmeDaughterBoardMemoryModule();

  public:
    const TVmeDaughterBoardMemoryModule& operator=( const TVmeDaughterBoardMemoryModule& right );
    Tbool operator==( const TVmeDaughterBoardMemoryModule& right ) const;
    Tbool operator!=( const TVmeDaughterBoardMemoryModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsamples );

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  private:
    TUshort modifyData( Tshort databuf ) const;

};

inline Tint TVmeDaughterBoardMemoryModule::GetNumberOfSampling() const
{
  return( theNumberOfSampling );
}

inline Tvoid TVmeDaughterBoardMemoryModule::SetNumberOfSampling( Tint nsamples )
{
  theNumberOfSampling = nsamples;
  return;
}

inline TUshort TVmeDaughterBoardMemoryModule::modifyData( Tshort databuf ) const
{
  // must be check!!
  // must be check!!
  // must be check!!
  TUshort retval;
  Tbit sign = ( databuf & 0x8000 ) >> 15;
  if ( sign ) { // negative value
    retval = databuf & 0x7fff;
    retval = databuf >> 4;
  } else { // positive value
    retval = databuf >> 4;
    retval = databuf + 0x07ff;
  }
  return( retval );
}

#endif
