// ============================================================================
//  $Id: TReadoutList.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutList::TReadoutList( const Tstring& id )
  : TReadoutIdentification( id ), TReadoutSectionList()
{;}

TReadoutList::TReadoutList( const TReadoutList& right )
  : TReadoutIdentification( right ), TReadoutSectionList( right )
{;}

TReadoutList::~TReadoutList()
{;}

TDataRecord TReadoutList::ReadData()
{
  TDataRecord record( theID );

  for ( Tsize_t i = 0; i < size(); i ++ )
    record.push_back( ( (*this)[ i ] ).ReadData() );

  return( record );
}

const TReadoutList& TReadoutList::operator=( const TReadoutList& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutSectionList*)this ) = *( (TReadoutSectionList*)(&right) );
  return( *this );
}

Tbool TReadoutList::operator==( const TReadoutList& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutSectionList*)this ) == *( (TReadoutSectionList*)(&right) ) );
  return( ret );
}

Tbool TReadoutList::operator!=( const TReadoutList& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutSectionList*)this ) != *( (TReadoutSectionList*)(&right) ) );
  return( ret );
}
