// ============================================================================
//  $Id: TReadoutSegment.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TREADOUTSEGMENT_HH
#define __TREADOUTSEGMENT_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutElementList.hh"

class TModule;
class TDataSegment;

class TReadoutSegment
  : public TReadoutIdentification, public TReadoutElementList
{

  private:
    TModule* theModule;

  public:
    TReadoutSegment( const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const TstringList& elementid, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring elementid[], const Tstring& id = TunknownID );
    TReadoutSegment( const TReadoutSegment& right );
    ~TReadoutSegment();

  public:
    const TReadoutSegment& operator=( const TReadoutSegment& right );
    Tbool operator==( const TReadoutSegment& right ) const;
    Tbool operator!=( const TReadoutSegment& right ) const;

  public:
    TDataSegment ReadData();

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

};

inline TModule* TReadoutSegment::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutSegment::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
