// ============================================================================
//  $Id: TOutputHtmlFileStream.hh,v 1.3 2002/12/08 21:21:48 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TOUTPUTHTMLFILESTREAM_HH
#define __TOUTPUTHTMLFILESTREAM_HH

#include "Tglobals.h"
#include "TRunInformationTable.hh"

class TOutputHtmlFileStream
  : public Tofstream
{

  public:
    enum ThtmlStream_t { tFooter, tHeader, tTable, tNumberOfStreamTypes };

  protected:
    TRunInformationTable theInformationTable;
    Tstring theTitle;

  public:
    TOutputHtmlFileStream();
    TOutputHtmlFileStream( const Tstring& title );
    TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table, const Tstring& title );
    TOutputHtmlFileStream( const TRunInformationTable& table );
    TOutputHtmlFileStream( const TRunInformationTable& table, const Tstring& title );
    TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table );
    TOutputHtmlFileStream( const Tstring& filename, const Tstring& title );
    ~TOutputHtmlFileStream();

  public:
    virtual TOutputHtmlFileStream& MakeTable();
    virtual TOutputHtmlFileStream& MakeHeaderParts();
    virtual TOutputHtmlFileStream& MakeFooterParts();
    friend TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& tos, ThtmlStream_t type );

  public:
    const TRunInformationTable& GetInformationTable() const;
    TRunInformationTable& GetInformationTable();
    Tvoid SetInformationTable( const TRunInformationTable& table );
    const Tstring& GetTitle() const;
    Tvoid SetTitle( const Tstring& title );
    Tvoid Open( const Tstring& filename );
    Tvoid Close();

};

inline const TRunInformationTable& TOutputHtmlFileStream::GetInformationTable() const
{
  return( theInformationTable );
}

inline TRunInformationTable& TOutputHtmlFileStream::GetInformationTable()
{
  return( theInformationTable );  
}

inline Tvoid TOutputHtmlFileStream::SetInformationTable( const TRunInformationTable& table )
{
  theInformationTable = table;
  return;
}

inline const Tstring& TOutputHtmlFileStream::GetTitle() const
{
  return( theTitle );
}

inline Tvoid TOutputHtmlFileStream::SetTitle( const Tstring& title )
{
  theTitle = title;
  return;
}

#endif
