// ============================================================================
//  $Id: fileInput.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TInputObjectSocket.hh"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exPort, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ] << Tspace << "<port>" << Tendl;
    return( -1 );
  }
  const Tint port = atoi( argv[ exPort ] );
  TInputObjectSocket isocket = TInputObjectSocket( port );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  while ( ( isocket >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetDataSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << isocket.GetTotalDataSize();
  Tcout << " byte data has been received." << Tendl;

  return( 0 );
}
