// ============================================================================
//  $Id: BtRunAction.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TRun.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"

#include "BtRunAction.hh"
#include "BtRunSummary.hh"

BtRunAction::BtRunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

BtRunAction::~BtRunAction()
{;}

Tvoid BtRunAction::BeginOfRunAction( TRun& aRun )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";

  Tint runid = aRun.GetRunID();
  Tstring filename = "run";
  Tstring runidstr = aRun.GetRunIDofString();
  if ( runid < 10 ) {
    filename += "00";
  } else if ( runid < 100 ) {
    filename += "0";
  }
  Tstring drecfile = filename + runidstr + drecext;
  Tstring htmlfile = filename + runidstr + htmlext;

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "run begin" );
  TSoftwareScalerModule* runnumber = (TSoftwareScalerModule*)( theCrate -> GetModule( "Run ID" ) );
  runnumber -> SetData( 0, runid );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> ReadData();
  *theOutputFile << record;

  theOutputHtml.Open( htmlfile );
  theRunSummary = new BtRunSummary();
  fillRunBeginInformation( record );

  return;
}

Tvoid BtRunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> ReadData();
  *theOutputFile << record;

  fillRunEndInformation( record );
  fillHtmlFile();
  theOutputHtml.Close();

  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;

  return;
}

Tvoid BtRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}

Tvoid BtRunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "INFO", "Run ID", "0" };
  static Tstring clockset[ 3 ] = { "INFO", "Clock", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunID( *( runid.GetIntData() ) );
  theRunSummary -> SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid BtRunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "INFO", "Clock", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );

  TRunInformationTable table = theRunManager -> GetRunInformationModule() -> GetRunInformationTable();
  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}

Tvoid BtRunAction::fillHtmlFile()
{
  TRunInformationTable table = theRunSummary -> GenerateRunSummaryTable();
  Tstring title = "Run Summary #" + ( theRunManager -> GetRun() ).GetRunIDofString();

  theOutputHtml.SetTitle( title );
  theOutputHtml.SetInformationTable( table );

  theOutputHtml << TOutputHtmlFileStream::tHeader << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tTable << Tendl;
  theOutputHtml << TOutputHtmlFileStream::tFooter << Tendl;

  return;
}
