// ============================================================================
//  $Id: DummyCrateDefinition.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCrate.hh"
#include "DummyCrateDefinition.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareFlashAdcModule.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareDataFileModule.hh"
#include "TRunInformationTable.hh"

DummyCrateDefinition::DummyCrateDefinition()
  : TCrateDefinition()
{;}

DummyCrateDefinition::~DummyCrateDefinition()
{;}

TCrate* DummyCrateDefinition::Define()
{
  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "OPERATOR" );
  itemlist.push_back( "BEAM ENERGY" );
  itemlist.push_back( "RUN TYPE" );
  itemlist.push_back( "COMMENT" );
  TstringList valuelist;
  valuelist.clear();
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  TRunInformationTable table = TRunInformationTable( itemlist, valuelist );

  TCrate* crate = new TCrate();

  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Run ID", "run begin initialize" );
  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Event ID", "run begin initialize" );
  crate -> InstallModule( new TSoftwareRunInformationModule( table ), "Run Information" );
  crate -> InstallModule( new TSoftwareClockModule( 1 ), "Clock", "run begin initialize" );
  crate -> InstallModule( new TSoftwareTimerModule( Tusec, 1 ), "Timer", "run begin initialize" );
  crate -> InstallModule( new TSoftwareFlashAdcModule(), "Flash ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareAdcModule(), "ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareInterruptRegisterModule( 1 ), "Interrupt Register", "run begin initialize" );
  crate -> InstallModule( new TSoftwareDataFileModule( "sample.g4dat", 2 ), "Geant4", "run begin initialize" );

  return( crate );
}
