// ============================================================================
//  $Id: DummyRunSummary.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "DummyRunSummary.hh"

DummyRunSummary::DummyRunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ),
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

DummyRunSummary::~DummyRunSummary()
{;}

Tvoid DummyRunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0;
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable DummyRunSummary::GenerateRunSummaryTable() const
{
  TstringList itemlist;
  TstringList valuelist;

  // BEGIN OF ITEM DEFINITION
  itemlist.push_back( "Run ID" );
  itemlist.push_back( "Identification of object file" );
  itemlist.push_back( "Size of object file" );
  itemlist.push_back( "Run Start" );
  itemlist.push_back( "Run Stop" );
  itemlist.push_back( "Number of events" );
  for ( Tsize_t i = 0; i < theRunInformationTable.GetItemList().size(); i ++ ) {
    Tstring strbuf;
    strbuf = "Run information (";
    strbuf += ( theRunInformationTable.GetItemList() )[ i ];
    strbuf += ")";
    itemlist.push_back( strbuf );
  }
  // END OF ITEM DEFINITION



  // BEGIN OF VALUE DEFINITION
  valuelist.push_back( itostr( theRunID ) );
  valuelist.push_back( theRecordName );
  valuelist.push_back( itostr( theRecordSize ) );
  valuelist.push_back( theRunBeginTime );
  valuelist.push_back( theRunEndTime );
  valuelist.push_back( itostr( theNumberOfEvents ) );
  for ( Tsize_t i = 0; i < theRunInformationTable.GetValueList().size(); i ++ ) {
    valuelist.push_back( ( theRunInformationTable.GetValueList() )[ i ] );
  }
  // BEGIN OF VALUE DEFINITION

  TRunInformationTable table( itemlist, valuelist );
  return( table );
}
