// ============================================================================
//  $Id: TAnalysisStopCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TAnalysisStopCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/stop";
static const Tstring _desc = "stop an analysis.";

TAnalysisStopCommand::TAnalysisStopCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStopCommand::~TAnalysisStopCommand()
{;}

Tvoid TAnalysisStopCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StopAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StopAnalysis( arguments[ i ] );
  }
  return;
}
