// ============================================================================
//  $Id: THelpCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "THelpCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "help";
static const Tstring _desc = "print a detail of command given as argument.";

THelpCommand::THelpCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

THelpCommand::~THelpCommand()
{;}

Tvoid THelpCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();
  TCommand* com = 0;
  com = ui -> FindCommand( arguments[ 0 ] );
  if ( com != 0 ) {
    com -> ShowCommandDetail();
  } else {
    ui -> NotFoundCommand( arguments[ 0 ] );
  }

  return;
}
