// ============================================================================
//  $Id: TInitializeRunInformationModuleCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TInitializeRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/initinfo";
static const Tstring _desc = "initialize run information in the table.";

TInitializeRunInformationModuleCommand::TInitializeRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TInitializeRunInformationModuleCommand::~TInitializeRunInformationModuleCommand()
{;}

Tvoid TInitializeRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TInitializeRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    theRunInformationModule -> Initialize();
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }
  return;
}
