// ============================================================================
//  $Id: TPrintEnvironmentVariableCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TPrintEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "printenv";
static const Tstring _desc = "print all or part of environment.\nexample> printenv ITEM\nexample> printenv";

TPrintEnvironmentVariableCommand::TPrintEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TPrintEnvironmentVariableCommand::~TPrintEnvironmentVariableCommand()
{;}

Tvoid TPrintEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TPrintEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcout << *theEnvironmentVariableTable << Tendl;
  } else if ( arguments.size() == 1 ) {
    Tcout << theEnvironmentVariableTable -> GetEnvironmentValue( arguments[ 0 ] ) << Tendl;
  } else {
    ShowCommandDetail();
  }
  return;
}
