// ============================================================================
//  $Id: TRunStartCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunStartCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/start";
static const Tstring _desc = "start a run.\nif you give a argument, set to run identification.\nhowever, it is omittable.\nexample> /run/start\nexample> /run/start 12345";

TRunStartCommand::TRunStartCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunStartCommand::~TRunStartCommand()
{;}

Tvoid TRunStartCommand::Execute( const TstringList& arguments )
{
  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring runid = arguments[ 0 ];
      theRunManager -> StartRun( strtol( runid.c_str(), 0, 0 ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  theRunManager -> StartRun();

  return;
}
