// ============================================================================
//  $Id: TRunTimeLimitCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunTimeLimitCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/timelimit";
static const Tstring _desc = "set time limit in second for a run scheduling.\nexample> /run/timelimit 3600 // an hour.";

TRunTimeLimitCommand::TRunTimeLimitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunTimeLimitCommand::~TRunTimeLimitCommand()
{;}

Tvoid TRunTimeLimitCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TRunTimeLimitCommand::Execute: ";
  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusStandby ) {
    if ( arguments.size() == 1 ) {
      TUint timesec = strtoul( arguments[ 0 ].c_str(), 0, 0 );
      alarm( timesec );
    } else {
      ShowCommandDetail();
    }
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby." << Tendl;
  }
  return;
}
