// ============================================================================
//  $Id: TShowRunInformationModuleCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TShowRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/showinfo";
static const Tstring _desc = "show run information in the table.";

TShowRunInformationModuleCommand::TShowRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TShowRunInformationModuleCommand::~TShowRunInformationModuleCommand()
{;}

Tvoid TShowRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TShowRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }
  TRunInformationTable& table = 
    theRunInformationModule -> GetRunInformationTable();
  if ( table.GetNumberOfRows() > 0 )
    Tcout << table << Tendl;
  return;
}
